/*
 * Decompiled with CFR 0.152.
 */
package org.thinkingstudio.obsidianui.hud;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.thinkingstudio.obsidianui.hud.Hud;

public class HudManager {
    public static final Map<class_2960, Hud> HUDS = new Object2ObjectOpenHashMap();

    public static void initAll(@NotNull class_310 client, int screenWidth, int screenHeight) {
        if (!HudManager.canRenderHuds(client)) {
            return;
        }
        HUDS.forEach((id, hud) -> {
            if (hud.isEnabled()) {
                hud.init(client, screenWidth, screenHeight);
            }
        });
    }

    public static void register(@NotNull Hud hud) {
        if (HUDS.containsKey(hud.getIdentifier())) {
            throw new IllegalArgumentException("Cannot register the same HUD twice!");
        }
        HUDS.put(hud.getIdentifier(), hud);
    }

    public static void unregister(@NotNull class_2960 identifier) {
        HUDS.remove(identifier);
    }

    public static void unregister(@NotNull Hud hud) {
        HudManager.unregister(hud.getIdentifier());
    }

    public static boolean canRenderHuds(@NotNull class_310 client) {
        return client.field_1687 != null && (!client.field_1690.field_1842 || client.field_1755 != null);
    }

    public static Optional<Hud> getHud(@NotNull class_2960 identifier) {
        return Optional.ofNullable(HUDS.get(identifier));
    }

    public static Collection<Hud> getHuds() {
        return HUDS.values();
    }
}

